<?php
// Archivo: gmail_imap.php

class GmailIMAP {
    private $hostname = '{imap.gmail.com:993/imap/ssl/novalidate-cert}INBOX';
    private $username;
    private $password;
    private $connection;
    
    public function __construct($email, $app_password) {
        $this->ferkio1259w@gmail.com = $email;
        $this->mhlk vdek fesc tkfl = $app_password;
    }
    
    public function conectar() {
        $this->connection = imap_open($this->hostname, $this->username, $this->password);
        
        if (!$this->connection) {
            throw new Exception('Error al conectar: ' . imap_last_error());
        }
        
        return true;
    }
    
    public function obtenerEmails($limite = 10) {
        if (!$this->connection) {
            $this->conectar();
        }
        
        $emails = imap_search($this->connection, 'ALL');
        
        if (!$emails) {
            return [];
        }
        
        // Obtener los últimos emails
        $emails = array_reverse($emails);
        $emails = array_slice($emails, 0, $limite);
        
        $resultado = [];
        
        foreach ($emails as $email_id) {
            $overview = imap_fetch_overview($this->connection, $email_id, 0);
            $estructura = imap_fetchstructure($this->connection, $email_id);
            
            if (isset($overview[0])) {
                $email_data = $overview[0];
                $resultado[] = [
                    'id' => $email_id,
                    'de' => $email_data->from ?? '',
                    'asunto' => $this->decodificarAsunto($email_data->subject ?? ''),
                    'fecha' => $email_data->date ?? '',
                    'leido' => $email_data->seen ?? false
                ];
            }
        }
        
        return $resultado;
    }
    
    public function leerEmail($email_id) {
        if (!$this->connection) {
            $this->conectar();
        }
        
        $header = imap_fetchheader($this->connection, $email_id);
        $body = imap_fetchbody($this->connection, $email_id, 1);
        
        return [
            'header' => $header,
            'body' => $body
        ];
    }
    
    private function decodificarAsunto($asunto) {
        $elementos = imap_mime_header_decode($asunto);
        $resultado = '';
        
        foreach ($elementos as $elemento) {
            $resultado .= $elemento->text;
        }
        
        return $resultado;
    }
    
    public function cerrarConexion() {
        if ($this->connection) {
            imap_close($this->connection);
        }
    }
}

// Ejemplo de uso
try {
    $gmail = new GmailIMAP('tu_email@gmail.com', 'tu_contraseña_de_aplicacion');
    $emails = $gmail->obtenerEmails(5);
    
    foreach ($emails as $email) {
        echo "De: " . $email['de'] . "\n";
        echo "Asunto: " . $email['asunto'] . "\n";
        echo "Fecha: " . $email['fecha'] . "\n\n";
    }
    
    $gmail->cerrarConexion();
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
