<?php
include 'includes/header.php';

$configFile = __DIR__ . '/config_sport.json';

$defaultConfig = [
    'use_default' => true,
    'default_url' => 'https://sys.rgvip.xyz/rgvip_sport.php',
    'custom_url' => '',
    'scroll_speed' => 3000,
    'scroll_amount' => -10
];

// Si no existe el archivo, lo crea
if (!file_exists($configFile)) {
    file_put_contents($configFile, json_encode($defaultConfig, JSON_PRETTY_PRINT));
}

// Si se envía el formulario, actualiza la configuración
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $updatedConfig = json_decode(file_get_contents($configFile), true);

    $updatedConfig['use_default'] = isset($_POST['use_default']);
    $updatedConfig['custom_url'] = trim($_POST['custom_url']);
    $updatedConfig['scroll_speed'] = (int)$_POST['scroll_speed'];
    $updatedConfig['scroll_amount'] = (int)$_POST['scroll_amount'];

    file_put_contents($configFile, json_encode($updatedConfig, JSON_PRETTY_PRINT));
    $message = "✅ Configuración actualizada.";
}

$currentConfig = json_decode(file_get_contents($configFile), true);
?>

<div class="col-md-8 mx-auto">
            <div class="card-body">
                <div class="card bg-dark text-white">
                    <div class="card-header card-header-warning">
                        <center>
            <h2 class="mb-9">Configurar web para botón de Deportes</h2>

    <?php if (!empty($message)): ?>
        <div class="alert alert-success"><?= $message ?></div>
    <?php endif; ?>

    <form method="post">
        <div class="form-check mb-3">
            <input class="form-check-input" type="checkbox" name="use_default" id="use_default"
                   <?= $currentConfig['use_default'] ? 'checked' : '' ?>>
            <label class="form-check-label" for="use_default">
                Usar URL por defecto (Api de deportes RGVIP)
            </label>
        </div>

        <div class="form-group">
            <label for="custom_url">URL personalizada (si *no* usas la por defecto)</label>
            <input type="url" name="custom_url" id="custom_url" class="form-control"
                   value="<?= htmlspecialchars($currentConfig['custom_url']) ?>">
        </div>

        <!--<div class="form-group">
            <label for="scroll_speed">Velocidad de Scroll (milisegundos)</label>
            <input type="number" name="scroll_speed" id="scroll_speed" class="form-control"
                   value="<?= htmlspecialchars($currentConfig['scroll_speed']) ?>">
        </div>

        <div class="form-group">
            <label for="scroll_amount">Cantidad de Scroll (píxeles)</label>
            <input type="number" name="scroll_amount" id="scroll_amount" class="form-control"
                   value="<?= htmlspecialchars($currentConfig['scroll_amount']) ?>">
        </div>-->

        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Guardar configuración
        </button>
    </form>
</div>

<?php include 'includes/footer.php'; ?>
