<?php
$configFile = __DIR__ . '/../config_sport.json';

$defaultConfig = [
    'use_default' => true,
    'default_url' => 'https://sys.rgvip.xyz/rgvip_sport.php',
    'custom_url' => '',
    'scroll_speed' => 3000,
    'scroll_amount' => -10
];

// Si no existe, lo crea con la configuración por defecto
if (!file_exists($configFile)) {
    file_put_contents($configFile, json_encode($defaultConfig, JSON_PRETTY_PRINT));
}

$config = json_decode(file_get_contents($configFile), true);
$url = $config['use_default'] ? $config['default_url'] : $config['custom_url'];
$scrollSpeed = (int)$config['scroll_speed'];
$scrollAmount = (int)$config['scroll_amount'];

$htmlContent = <<<HTML
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>WebView</title>
    <style>
        body { margin: 0; overflow: hidden; }
        iframe { width: 100%; height: 100vh; border: none; }
    </style>
</head>
<body>
    <iframe id="webview" src="$url" frameborder="0" allowfullscreen></iframe>
    <script>
        document.getElementById('webview').onload = function() {
            setInterval(function() {
                window.scrollBy(0, $scrollAmount);
            }, $scrollSpeed);
        };
    </script>
</body>
</html>
HTML;

header("Content-Type: text/html");
echo $htmlContent;
?>
